(function() {
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'collections/contacts/ContactCollection', 'models/contact/ContactModel', 'views/contact/ContactView', "views/menu/MenuView", 'views/contact/FormContactView', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, ContactCollection, ContactModel, ContactView, MenuView, FormContactView) {
    var ListItemCollection, ListItemModel, ListView;
    ListItemModel = (function() {
      class ListItemModel extends Backbone.Model {};

      ListItemModel.prototype.defaults = {
        userID: '',
        userName: ''
      };

      return ListItemModel;

    }).call(this);
    ListItemCollection = (function() {
      class ListItemCollection extends Backbone.Collection {
        getList() {
          var j, len, m, ref, res;
          res = [];
          ref = this.models;
          for (j = 0, len = ref.length; j < len; j++) {
            m = ref[j];
            res.push(m.attributes);
          }
          return res;
        }

        load() {
          return this.trigger('collectionFilled');
        }

        findByName(subString) {
          var item, j, len, list, res;
          res = [];
          list = this.getList();
          for (j = 0, len = list.length; j < len; j++) {
            item = list[j];
            if (item.userName.toLowerCase().indexOf(subString.toLowerCase()) !== -1) {
              res.push(item);
            }
          }
          return res;
        }

      };

      ListItemCollection.prototype.model = ListItemModel;

      return ListItemCollection;

    }).call(this);
    return ListView = class ListView extends Backbone.View {
      initialize(title, searchPlaceholder, usr, list1) {
        this.title = title;
        this.searchPlaceholder = searchPlaceholder;
        this.usr = usr;
        this.list = list1;
        this.collection = new ListItemCollection(this.list);
        this.collection.on('collectionFilled', this.collectionFilled, this);
        return this.NContactsPerPage = 500;
      }

      events() {
        return {
          'tap #id-ul-list-generic > li': 'btnItemClicked',
          'tap #id-btn-panel': 'btnPanelClicked',
          'keyup #id-input-search-list': 'inputSearchChanged',
          'change #id-input-search-list': 'inputSearchChanged',
          'pageshow': 'pageShown'
        };
      }

      render() {
        var template;
        template = Handlebars.templates['ListView'];
        this.$el.html(template({
          user: this.usr.toJSON(),
          title: this.title,
          searchPlaceholder: this.searchPlaceholder
        }));
        this.$el.find('#id-ul-list-generic').show();
        this.$el.attr('id', 'id-ListView');
        this.addSidePanel();
        return this.$el;
      }

      pageShown() {
        $('#id-ul-list-generic li').removeClass('selected');
        return this.collection.load();
      }

      //HANDLING OF SIDE PANEL AND NAVIGATION
      addSidePanel() {
        if (!MenuView) {
          MenuView = require("views/menu/MenuView");
        }
        this.panel = new MenuView(this.usr);
        this.panel.render();
        return this.$el.append(this.panel.el);
      }

      collectionFilled() {
        this.$el.find('#id-spinner-all').hide();
        this.$el.find('#id-input-search-list').textinput('enable');
        return this.update_list();
      }

      update_list(items) {
        var i, itemsPerPage, ulc;
        if (typeof items === 'undefined' || items.length === 0) {
          items = this.collection.getList();
        }
        ulc = this.$el.find('#id-ul-list-generic');
        ulc.empty();
        i = 0;
        itemsPerPage = this.NContactsPerPage;
        _.each(items, (item) => {
          var id, li, name;
          id = item.userID;
          name = item.userName;
          if (!(_.isUndefined(name) || !name)) {
            li = `<li data-userID='${id}' data-userName='${name}' style='min-height: initial;'> <div style='display: table; width: 100%; vertical-align: middle;'> <div style='display: table-cell; width: 90%; vertical-align: middle;'> <span class='header' style='position: initial; display: block; float: left; width: 100%; max-width: initial;'>${name}</span> </div> </div> </li>`;
            ulc.append(li);
          }
          return i += 1;
        });
        ulc.show();
        return ulc.listview('refresh');
      }

      btnPanelClicked(event) {
        return this.panel.btnPanelClicked(event);
      }

      btnItemClicked(event) {
        var iView, obj, objName, userID, userName, view;
        event.stopPropagation();
        event.preventDefault();
        obj = $(event.currentTarget);
        obj.addClass('selected');
        objName = obj.text();
        userID = obj.attr('data-userID');
        userName = obj.attr('data-userName');
        if (userID === 'empty') {
          return;
        }
        obj = new ListItemModel();
        iView = $.mobile.jqmNavigator.getViews().length - 2;
        view = $.mobile.jqmNavigator.getViews()[iView];
        obj.on('change', _.bind(view.listItemSelected, this, view));
        return obj.set({
          userID: userID,
          userName: userName
        });
      }

      inputSearchChanged(event) {
        var col, input, query;
        input = $(event.currentTarget);
        query = input.val();
        if (query.length >= 3) {
          col = this.collection.findByName(query);
          return this.update_list(col);
        } else if (query.length === 0) {
          return this.update_list();
        }
      }

      contact_deleted() {
        return this.$el.find('#id-ul-list-generic').empty();
      }

      __get_contacts_collection() {
        return this.collection.get_contacts(this.usr).toJSON();
      }

    };
  });

}).call(this);
